%------------------------------------------------------------------------------
% File     : NUM636^1 : TPTP v7.4.0. Released v3.7.0.
% Domain   : Number Theory
% Problem  : Landau theorem 2
% Version  : Especial.
% English  : ~(suc x = x)

% Refs     : [Lan30] Landau (1930), Grundlagen der Analysis
%          : [vBJ79] van Benthem Jutting (1979), Checking Landau's "Grundla
%          : [Bro09] Brown (2009), Email to Geoff Sutcliffe
% Source   : [Bro09]
% Names    : satz2 [Lan30]

% Status   : Theorem
%          : Without extensionality : Theorem
% Rating   : 0.43 v7.4.0, 0.33 v7.2.0, 0.38 v7.0.0, 0.29 v6.4.0, 0.33 v6.3.0, 0.40 v6.2.0, 0.71 v5.5.0, 0.83 v5.4.0, 0.80 v5.2.0, 1.00 v3.7.0
% Syntax   : Number of formulae    :   13 (   0 unit;   7 type;   0 defn)
%            Number of atoms       :   41 (   4 equality;  20 variable)
%            Maximal formula depth :    9 (   4 average)
%            Number of connectives :   31 (   4   ~;   0   |;   0   &;  21   @)
%                                         (   0 <=>;   6  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :    7 (   7   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :    9 (   7   :;   0   =)
%            Number of variables   :   10 (   0 sgn;  10   !;   0   ?;   0   ^)
%                                         (  10   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : 
%------------------------------------------------------------------------------
thf(nat_type,type,(
    nat: $tType )).

thf(x,type,(
    x: nat )).

thf(suc,type,(
    suc: nat > nat )).

thf(set_type,type,(
    set: $tType )).

thf(esti,type,(
    esti: nat > set > $o )).

thf(setof,type,(
    setof: ( nat > $o ) > set )).

thf(estie,axiom,(
    ! [Xp: nat > $o,Xs: nat] :
      ( ( esti @ Xs @ ( setof @ Xp ) )
     => ( Xp @ Xs ) ) )).

thf(n_1,type,(
    n_1: nat )).

thf(ax5,axiom,(
    ! [Xs: set] :
      ( ( esti @ n_1 @ Xs )
     => ( ! [Xx: nat] :
            ( ( esti @ Xx @ Xs )
           => ( esti @ ( suc @ Xx ) @ Xs ) )
       => ! [Xx: nat] :
            ( esti @ Xx @ Xs ) ) ) )).

thf(estii,axiom,(
    ! [Xp: nat > $o,Xs: nat] :
      ( ( Xp @ Xs )
     => ( esti @ Xs @ ( setof @ Xp ) ) ) )).

thf(ax3,axiom,(
    ! [Xx: nat] :
      ( ( suc @ Xx )
     != n_1 ) )).

thf(satz1,axiom,(
    ! [Xx: nat,Xy: nat] :
      ( ( Xx != Xy )
     => ( ( suc @ Xx )
       != ( suc @ Xy ) ) ) )).

thf(satz2,conjecture,(
    ( suc @ x )
 != x )).

%------------------------------------------------------------------------------
